import React from 'react';

interface InputProps extends React.InputHTMLAttributes<HTMLInputElement> {
  label: string;
  error?: string;
}

export const Input: React.FC<InputProps> = ({ label, error, className = '', ...props }) => {
  return (
    <div className="w-full">
      <label className="block text-[10px] font-bold tracking-widest text-zinc-500 mb-2 uppercase">
        {label}
      </label>
      <input
        className={`
          w-full bg-zinc-900/50 border text-white px-4 py-3 rounded-2xl text-sm
          placeholder-zinc-700 focus:outline-none focus:border-white focus:bg-black
          transition-all duration-300
          ${error ? 'border-red-900 focus:border-red-500' : 'border-zinc-800'}
          ${className}
        `}
        {...props}
      />
      {error && (
        <p className="text-red-500 text-[10px] mt-1.5 font-medium tracking-wide">{error}</p>
      )}
    </div>
  );
};