import React from 'react';
import { SOCIAL_LINKS } from '../constants';

export const SocialFooter: React.FC = () => {
  return (
    <div className="mt-12 w-full text-center animate-slide-up" style={{ animationDelay: '0.2s' }}>
      <p className="text-zinc-500 text-xs font-bold tracking-[0.2em] mb-6 uppercase">
        Síguenos en redes
      </p>
      <div className="flex justify-center gap-6">
        {SOCIAL_LINKS.map((social) => (
          <a
            key={social.name}
            href={social.url}
            target="_blank"
            rel="noopener noreferrer"
            className="group flex flex-col items-center gap-2 hover:-translate-y-1 transition-transform duration-300"
          >
            <div className="w-10 h-10 rounded-full border border-zinc-700 flex items-center justify-center bg-zinc-900 text-zinc-400 group-hover:border-white group-hover:bg-white group-hover:text-black transition-colors duration-300">
               {/* Simple Icons based on name */}
               {social.name === 'Instagram' && (
                 <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"><rect x="2" y="2" width="20" height="20" rx="5" ry="5"></rect><path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path><line x1="17.5" y1="6.5" x2="17.51" y2="6.5"></line></svg>
               )}
               {social.name === 'Facebook' && (
                 <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"><path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"></path></svg>
               )}
               {social.name === 'TikTok' && (
                  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"><path d="M9 12a4 4 0 1 0 4 4V4a5 5 0 0 0 5 5"></path></svg>
               )}
               {social.name === 'X' && (
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="currentColor"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
               )}
            </div>
          </a>
        ))}
      </div>
    </div>
  );
};