import { Country } from "./types";

// COPIA AQUI LA URL DE TU SCRIPT DE GOOGLE APPS SCRIPT
// Ejemplo: "https://script.google.com/macros/s/AKfycbx.../exec"
export const GOOGLE_SHEETS_SCRIPT_URL = "https://script.google.com/macros/s/AKfycbzaVYPdaL2q_DJV84P-weVhiErkdYgNQYzot3k6R4wMh9_JU7S-k04ehtZupN-by20j/exec"; 

export const WHATSAPP_CHANNEL_URL = "https://www.whatsapp.com/channel/0029Vb6iwXg8vd1IDWGLL21u";
export const BACKGROUND_IMAGE_URL = "https://i.postimg.cc/jqpjYMgf/Ring-de-Boxeo.jpg";

export const SOCIAL_LINKS = [
  { name: 'Instagram', url: '#', label: '@primacyboxing' },
  { name: 'Facebook', url: '#', label: 'Primacy Boxing' },
  { name: 'TikTok', url: '#', label: '@primacyboxing' },
  { name: 'X', url: '#', label: '@primacyboxing' },
];

// Comprehensive list of countries
export const COUNTRIES: Country[] = [
    { name: "Afghanistan", code: "AF", dial_code: "+93", maxDigits: 9 },
    { name: "Albania", code: "AL", dial_code: "+355", maxDigits: 9 },
    { name: "Algeria", code: "DZ", dial_code: "+213", maxDigits: 9 },
    { name: "American Samoa", code: "AS", dial_code: "+1684", maxDigits: 7 },
    { name: "Andorra", code: "AD", dial_code: "+376", maxDigits: 6 },
    { name: "Angola", code: "AO", dial_code: "+244", maxDigits: 9 },
    { name: "Anguilla", code: "AI", dial_code: "+1264", maxDigits: 7 },
    { name: "Antarctica", code: "AQ", dial_code: "+672", maxDigits: 6 },
    { name: "Antigua and Barbuda", code: "AG", dial_code: "+1268", maxDigits: 7 },
    { name: "Argentina", code: "AR", dial_code: "+54", maxDigits: 11 },
    { name: "Armenia", code: "AM", dial_code: "+374", maxDigits: 8 },
    { name: "Aruba", code: "AW", dial_code: "+297", maxDigits: 7 },
    { name: "Australia", code: "AU", dial_code: "+61", maxDigits: 9 },
    { name: "Austria", code: "AT", dial_code: "+43", maxDigits: 10 },
    { name: "Azerbaijan", code: "AZ", dial_code: "+994", maxDigits: 9 },
    { name: "Bahamas", code: "BS", dial_code: "+1242", maxDigits: 7 },
    { name: "Bahrain", code: "BH", dial_code: "+973", maxDigits: 8 },
    { name: "Bangladesh", code: "BD", dial_code: "+880", maxDigits: 10 },
    { name: "Barbados", code: "BB", dial_code: "+1246", maxDigits: 7 },
    { name: "Belarus", code: "BY", dial_code: "+375", maxDigits: 9 },
    { name: "Belgium", code: "BE", dial_code: "+32", maxDigits: 9 },
    { name: "Belize", code: "BZ", dial_code: "+501", maxDigits: 7 },
    { name: "Benin", code: "BJ", dial_code: "+229", maxDigits: 8 },
    { name: "Bermuda", code: "BM", dial_code: "+1441", maxDigits: 7 },
    { name: "Bhutan", code: "BT", dial_code: "+975", maxDigits: 8 },
    { name: "Bolivia", code: "BO", dial_code: "+591", maxDigits: 8 },
    { name: "Bosnia and Herzegovina", code: "BA", dial_code: "+387", maxDigits: 8 },
    { name: "Botswana", code: "BW", dial_code: "+267", maxDigits: 8 },
    { name: "Brazil", code: "BR", dial_code: "+55", maxDigits: 11 },
    { name: "British Indian Ocean Territory", code: "IO", dial_code: "+246", maxDigits: 7 },
    { name: "British Virgin Islands", code: "VG", dial_code: "+1284", maxDigits: 7 },
    { name: "Brunei", code: "BN", dial_code: "+673", maxDigits: 7 },
    { name: "Bulgaria", code: "BG", dial_code: "+359", maxDigits: 9 },
    { name: "Burkina Faso", code: "BF", dial_code: "+226", maxDigits: 8 },
    { name: "Burundi", code: "BI", dial_code: "+257", maxDigits: 8 },
    { name: "Cambodia", code: "KH", dial_code: "+855", maxDigits: 9 },
    { name: "Cameroon", code: "CM", dial_code: "+237", maxDigits: 9 },
    { name: "Canada", code: "CA", dial_code: "+1", maxDigits: 10 },
    { name: "Cape Verde", code: "CV", dial_code: "+238", maxDigits: 7 },
    { name: "Cayman Islands", code: "KY", dial_code: "+1345", maxDigits: 7 },
    { name: "Central African Republic", code: "CF", dial_code: "+236", maxDigits: 8 },
    { name: "Chad", code: "TD", dial_code: "+235", maxDigits: 8 },
    { name: "Chile", code: "CL", dial_code: "+56", maxDigits: 9 },
    { name: "China", code: "CN", dial_code: "+86", maxDigits: 11 },
    { name: "Christmas Island", code: "CX", dial_code: "+61", maxDigits: 9 },
    { name: "Cocos Islands", code: "CC", dial_code: "+61", maxDigits: 9 },
    { name: "Colombia", code: "CO", dial_code: "+57", maxDigits: 10 },
    { name: "Comoros", code: "KM", dial_code: "+269", maxDigits: 7 },
    { name: "Cook Islands", code: "CK", dial_code: "+682", maxDigits: 5 },
    { name: "Costa Rica", code: "CR", dial_code: "+506", maxDigits: 8 },
    { name: "Croatia", code: "HR", dial_code: "+385", maxDigits: 9 },
    { name: "Cuba", code: "CU", dial_code: "+53", maxDigits: 8 },
    { name: "Curacao", code: "CW", dial_code: "+599", maxDigits: 7 },
    { name: "Cyprus", code: "CY", dial_code: "+357", maxDigits: 8 },
    { name: "Czech Republic", code: "CZ", dial_code: "+420", maxDigits: 9 },
    { name: "Democratic Republic of the Congo", code: "CD", dial_code: "+243", maxDigits: 9 },
    { name: "Denmark", code: "DK", dial_code: "+45", maxDigits: 8 },
    { name: "Djibouti", code: "DJ", dial_code: "+253", maxDigits: 8 },
    { name: "Dominica", code: "DM", dial_code: "+1767", maxDigits: 7 },
    { name: "Dominican Republic", code: "DO", dial_code: "+1", maxDigits: 10 },
    { name: "East Timor", code: "TL", dial_code: "+670", maxDigits: 7 },
    { name: "Ecuador", code: "EC", dial_code: "+593", maxDigits: 9 },
    { name: "Egypt", code: "EG", dial_code: "+20", maxDigits: 10 },
    { name: "El Salvador", code: "SV", dial_code: "+503", maxDigits: 8 },
    { name: "Equatorial Guinea", code: "GQ", dial_code: "+240", maxDigits: 9 },
    { name: "Eritrea", code: "ER", dial_code: "+291", maxDigits: 7 },
    { name: "Estonia", code: "EE", dial_code: "+372", maxDigits: 8 },
    { name: "Ethiopia", code: "ET", dial_code: "+251", maxDigits: 9 },
    { name: "Falkland Islands", code: "FK", dial_code: "+500", maxDigits: 5 },
    { name: "Faroe Islands", code: "FO", dial_code: "+298", maxDigits: 6 },
    { name: "Fiji", code: "FJ", dial_code: "+679", maxDigits: 7 },
    { name: "Finland", code: "FI", dial_code: "+358", maxDigits: 10 },
    { name: "France", code: "FR", dial_code: "+33", maxDigits: 9 },
    { name: "French Polynesia", code: "PF", dial_code: "+689", maxDigits: 8 },
    { name: "Gabon", code: "GA", dial_code: "+241", maxDigits: 7 },
    { name: "Gambia", code: "GM", dial_code: "+220", maxDigits: 7 },
    { name: "Georgia", code: "GE", dial_code: "+995", maxDigits: 9 },
    { name: "Germany", code: "DE", dial_code: "+49", maxDigits: 11 },
    { name: "Ghana", code: "GH", dial_code: "+233", maxDigits: 9 },
    { name: "Gibraltar", code: "GI", dial_code: "+350", maxDigits: 8 },
    { name: "Greece", code: "GR", dial_code: "+30", maxDigits: 10 },
    { name: "Greenland", code: "GL", dial_code: "+299", maxDigits: 6 },
    { name: "Grenada", code: "GD", dial_code: "+1473", maxDigits: 7 },
    { name: "Guam", code: "GU", dial_code: "+1671", maxDigits: 7 },
    { name: "Guatemala", code: "GT", dial_code: "+502", maxDigits: 8 },
    { name: "Guernsey", code: "GG", dial_code: "+44", maxDigits: 10 },
    { name: "Guinea", code: "GN", dial_code: "+224", maxDigits: 9 },
    { name: "Guinea-Bissau", code: "GW", dial_code: "+245", maxDigits: 9 },
    { name: "Guyana", code: "GY", dial_code: "+592", maxDigits: 7 },
    { name: "Haiti", code: "HT", dial_code: "+509", maxDigits: 8 },
    { name: "Honduras", code: "HN", dial_code: "+504", maxDigits: 8 },
    { name: "Hong Kong", code: "HK", dial_code: "+852", maxDigits: 8 },
    { name: "Hungary", code: "HU", dial_code: "+36", maxDigits: 9 },
    { name: "Iceland", code: "IS", dial_code: "+354", maxDigits: 7 },
    { name: "India", code: "IN", dial_code: "+91", maxDigits: 10 },
    { name: "Indonesia", code: "ID", dial_code: "+62", maxDigits: 11 },
    { name: "Iran", code: "IR", dial_code: "+98", maxDigits: 10 },
    { name: "Iraq", code: "IQ", dial_code: "+964", maxDigits: 10 },
    { name: "Ireland", code: "IE", dial_code: "+353", maxDigits: 9 },
    { name: "Isle of Man", code: "IM", dial_code: "+44", maxDigits: 10 },
    { name: "Israel", code: "IL", dial_code: "+972", maxDigits: 9 },
    { name: "Italy", code: "IT", dial_code: "+39", maxDigits: 10 },
    { name: "Ivory Coast", code: "CI", dial_code: "+225", maxDigits: 10 },
    { name: "Jamaica", code: "JM", dial_code: "+1876", maxDigits: 7 },
    { name: "Japan", code: "JP", dial_code: "+81", maxDigits: 10 },
    { name: "Jersey", code: "JE", dial_code: "+44", maxDigits: 10 },
    { name: "Jordan", code: "JO", dial_code: "+962", maxDigits: 9 },
    { name: "Kazakhstan", code: "KZ", dial_code: "+7", maxDigits: 10 },
    { name: "Kenya", code: "KE", dial_code: "+254", maxDigits: 9 },
    { name: "Kiribati", code: "KI", dial_code: "+686", maxDigits: 5 },
    { name: "Kosovo", code: "XK", dial_code: "+383", maxDigits: 8 },
    { name: "Kuwait", code: "KW", dial_code: "+965", maxDigits: 8 },
    { name: "Kyrgyzstan", code: "KG", dial_code: "+996", maxDigits: 9 },
    { name: "Laos", code: "LA", dial_code: "+856", maxDigits: 9 },
    { name: "Latvia", code: "LV", dial_code: "+371", maxDigits: 8 },
    { name: "Lebanon", code: "LB", dial_code: "+961", maxDigits: 8 },
    { name: "Lesotho", code: "LS", dial_code: "+266", maxDigits: 8 },
    { name: "Liberia", code: "LR", dial_code: "+231", maxDigits: 7 },
    { name: "Libya", code: "LY", dial_code: "+218", maxDigits: 9 },
    { name: "Liechtenstein", code: "LI", dial_code: "+423", maxDigits: 7 },
    { name: "Lithuania", code: "LT", dial_code: "+370", maxDigits: 8 },
    { name: "Luxembourg", code: "LU", dial_code: "+352", maxDigits: 9 },
    { name: "Macau", code: "MO", dial_code: "+853", maxDigits: 8 },
    { name: "Macedonia", code: "MK", dial_code: "+389", maxDigits: 8 },
    { name: "Madagascar", code: "MG", dial_code: "+261", maxDigits: 9 },
    { name: "Malawi", code: "MW", dial_code: "+265", maxDigits: 9 },
    { name: "Malaysia", code: "MY", dial_code: "+60", maxDigits: 10 },
    { name: "Maldives", code: "MV", dial_code: "+960", maxDigits: 7 },
    { name: "Mali", code: "ML", dial_code: "+223", maxDigits: 8 },
    { name: "Malta", code: "MT", dial_code: "+356", maxDigits: 8 },
    { name: "Marshall Islands", code: "MH", dial_code: "+692", maxDigits: 7 },
    { name: "Mauritania", code: "MR", dial_code: "+222", maxDigits: 8 },
    { name: "Mauritius", code: "MU", dial_code: "+230", maxDigits: 7 },
    { name: "Mayotte", code: "YT", dial_code: "+262", maxDigits: 9 },
    { name: "Mexico", code: "MX", dial_code: "+52", maxDigits: 10 },
    { name: "Micronesia", code: "FM", dial_code: "+691", maxDigits: 7 },
    { name: "Moldova", code: "MD", dial_code: "+373", maxDigits: 8 },
    { name: "Monaco", code: "MC", dial_code: "+377", maxDigits: 8 },
    { name: "Mongolia", code: "MN", dial_code: "+976", maxDigits: 8 },
    { name: "Montenegro", code: "ME", dial_code: "+382", maxDigits: 8 },
    { name: "Montserrat", code: "MS", dial_code: "+1664", maxDigits: 7 },
    { name: "Morocco", code: "MA", dial_code: "+212", maxDigits: 9 },
    { name: "Mozambique", code: "MZ", dial_code: "+258", maxDigits: 9 },
    { name: "Myanmar", code: "MM", dial_code: "+95", maxDigits: 9 },
    { name: "Namibia", code: "NA", dial_code: "+264", maxDigits: 9 },
    { name: "Nauru", code: "NR", dial_code: "+674", maxDigits: 7 },
    { name: "Nepal", code: "NP", dial_code: "+977", maxDigits: 10 },
    { name: "Netherlands", code: "NL", dial_code: "+31", maxDigits: 9 },
    { name: "New Caledonia", code: "NC", dial_code: "+687", maxDigits: 6 },
    { name: "New Zealand", code: "NZ", dial_code: "+64", maxDigits: 10 },
    { name: "Nicaragua", code: "NI", dial_code: "+505", maxDigits: 8 },
    { name: "Niger", code: "NE", dial_code: "+227", maxDigits: 8 },
    { name: "Nigeria", code: "NG", dial_code: "+234", maxDigits: 10 },
    { name: "Niue", code: "NU", dial_code: "+683", maxDigits: 4 },
    { name: "North Korea", code: "KP", dial_code: "+850", maxDigits: 10 },
    { name: "Northern Mariana Islands", code: "MP", dial_code: "+1670", maxDigits: 7 },
    { name: "Norway", code: "NO", dial_code: "+47", maxDigits: 8 },
    { name: "Oman", code: "OM", dial_code: "+968", maxDigits: 8 },
    { name: "Pakistan", code: "PK", dial_code: "+92", maxDigits: 10 },
    { name: "Palau", code: "PW", dial_code: "+680", maxDigits: 7 },
    { name: "Palestine", code: "PS", dial_code: "+970", maxDigits: 9 },
    { name: "Panama", code: "PA", dial_code: "+507", maxDigits: 8 },
    { name: "Papua New Guinea", code: "PG", dial_code: "+675", maxDigits: 8 },
    { name: "Paraguay", code: "PY", dial_code: "+595", maxDigits: 9 },
    { name: "Peru", code: "PE", dial_code: "+51", maxDigits: 9 },
    { name: "Philippines", code: "PH", dial_code: "+63", maxDigits: 10 },
    { name: "Pitcairn", code: "PN", dial_code: "+64", maxDigits: 8 },
    { name: "Poland", code: "PL", dial_code: "+48", maxDigits: 9 },
    { name: "Portugal", code: "PT", dial_code: "+351", maxDigits: 9 },
    { name: "Puerto Rico", code: "PR", dial_code: "+1", maxDigits: 10 },
    { name: "Qatar", code: "QA", dial_code: "+974", maxDigits: 8 },
    { name: "Republic of the Congo", code: "CG", dial_code: "+242", maxDigits: 9 },
    { name: "Romania", code: "RO", dial_code: "+40", maxDigits: 9 },
    { name: "Russia", code: "RU", dial_code: "+7", maxDigits: 10 },
    { name: "Rwanda", code: "RW", dial_code: "+250", maxDigits: 9 },
    { name: "Saint Barthelemy", code: "BL", dial_code: "+590", maxDigits: 9 },
    { name: "Saint Helena", code: "SH", dial_code: "+290", maxDigits: 4 },
    { name: "Saint Kitts and Nevis", code: "KN", dial_code: "+1869", maxDigits: 7 },
    { name: "Saint Lucia", code: "LC", dial_code: "+1758", maxDigits: 7 },
    { name: "Saint Martin", code: "MF", dial_code: "+590", maxDigits: 9 },
    { name: "Saint Pierre and Miquelon", code: "PM", dial_code: "+508", maxDigits: 6 },
    { name: "Saint Vincent and the Grenadines", code: "VC", dial_code: "+1784", maxDigits: 7 },
    { name: "Samoa", code: "WS", dial_code: "+685", maxDigits: 7 },
    { name: "San Marino", code: "SM", dial_code: "+378", maxDigits: 10 },
    { name: "Sao Tome and Principe", code: "ST", dial_code: "+239", maxDigits: 7 },
    { name: "Saudi Arabia", code: "SA", dial_code: "+966", maxDigits: 9 },
    { name: "Senegal", code: "SN", dial_code: "+221", maxDigits: 9 },
    { name: "Serbia", code: "RS", dial_code: "+381", maxDigits: 9 },
    { name: "Seychelles", code: "SC", dial_code: "+248", maxDigits: 7 },
    { name: "Sierra Leone", code: "SL", dial_code: "+232", maxDigits: 8 },
    { name: "Singapore", code: "SG", dial_code: "+65", maxDigits: 8 },
    { name: "Sint Maarten", code: "SX", dial_code: "+1721", maxDigits: 7 },
    { name: "Slovakia", code: "SK", dial_code: "+421", maxDigits: 9 },
    { name: "Slovenia", code: "SI", dial_code: "+386", maxDigits: 8 },
    { name: "Solomon Islands", code: "SB", dial_code: "+677", maxDigits: 7 },
    { name: "Somalia", code: "SO", dial_code: "+252", maxDigits: 9 },
    { name: "South Africa", code: "ZA", dial_code: "+27", maxDigits: 9 },
    { name: "South Korea", code: "KR", dial_code: "+82", maxDigits: 10 },
    { name: "South Sudan", code: "SS", dial_code: "+211", maxDigits: 9 },
    { name: "Spain", code: "ES", dial_code: "+34", maxDigits: 9 },
    { name: "Sri Lanka", code: "LK", dial_code: "+94", maxDigits: 9 },
    { name: "Sudan", code: "SD", dial_code: "+249", maxDigits: 9 },
    { name: "Suriname", code: "SR", dial_code: "+597", maxDigits: 7 },
    { name: "Svalbard and Jan Mayen", code: "SJ", dial_code: "+47", maxDigits: 8 },
    { name: "Swaziland", code: "SZ", dial_code: "+268", maxDigits: 8 },
    { name: "Sweden", code: "SE", dial_code: "+46", maxDigits: 9 },
    { name: "Switzerland", code: "CH", dial_code: "+41", maxDigits: 9 },
    { name: "Syria", code: "SY", dial_code: "+963", maxDigits: 9 },
    { name: "Taiwan", code: "TW", dial_code: "+886", maxDigits: 9 },
    { name: "Tajikistan", code: "TJ", dial_code: "+992", maxDigits: 9 },
    { name: "Tanzania", code: "TZ", dial_code: "+255", maxDigits: 9 },
    { name: "Thailand", code: "TH", dial_code: "+66", maxDigits: 9 },
    { name: "Togo", code: "TG", dial_code: "+228", maxDigits: 8 },
    { name: "Tokelau", code: "TK", dial_code: "+690", maxDigits: 4 },
    { name: "Tonga", code: "TO", dial_code: "+676", maxDigits: 5 },
    { name: "Trinidad and Tobago", code: "TT", dial_code: "+1868", maxDigits: 7 },
    { name: "Tunisia", code: "TN", dial_code: "+216", maxDigits: 8 },
    { name: "Turkey", code: "TR", dial_code: "+90", maxDigits: 10 },
    { name: "Turkmenistan", code: "TM", dial_code: "+993", maxDigits: 8 },
    { name: "Turks and Caicos Islands", code: "TC", dial_code: "+1649", maxDigits: 7 },
    { name: "Tuvalu", code: "TV", dial_code: "+688", maxDigits: 5 },
    { name: "U.S. Virgin Islands", code: "VI", dial_code: "+1340", maxDigits: 7 },
    { name: "Uganda", code: "UG", dial_code: "+256", maxDigits: 9 },
    { name: "Ukraine", code: "UA", dial_code: "+380", maxDigits: 9 },
    { name: "United Arab Emirates", code: "AE", dial_code: "+971", maxDigits: 9 },
    { name: "United Kingdom", code: "GB", dial_code: "+44", maxDigits: 10 },
    { name: "United States", code: "US", dial_code: "+1", maxDigits: 10 },
    { name: "Uruguay", code: "UY", dial_code: "+598", maxDigits: 8 },
    { name: "Uzbekistan", code: "UZ", dial_code: "+998", maxDigits: 9 },
    { name: "Vanuatu", code: "VU", dial_code: "+678", maxDigits: 7 },
    { name: "Vatican", code: "VA", dial_code: "+379", maxDigits: 10 },
    { name: "Venezuela", code: "VE", dial_code: "+58", maxDigits: 10 },
    { name: "Vietnam", code: "VN", dial_code: "+84", maxDigits: 9 },
    { name: "Wallis and Futuna", code: "WF", dial_code: "+681", maxDigits: 6 },
    { name: "Western Sahara", code: "EH", dial_code: "+212", maxDigits: 9 },
    { name: "Yemen", code: "YE", dial_code: "+967", maxDigits: 9 },
    { name: "Zambia", code: "ZM", dial_code: "+260", maxDigits: 9 },
    { name: "Zimbabwe", code: "ZW", dial_code: "+263", maxDigits: 9 }
].sort((a, b) => a.name.localeCompare(b.name));